//==================================================================================
// CaroneElevator. Base: ElevatorMover. Modified by Carone (Well, there's actually
// only a small percentage of original code in here)
// Please don't forget to give me credit for this and please notify me if you use it
// for a mod/map/level that's to be released
//==================================================================================

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// IMPORTANT
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// If you want the Elevator-Doors to be controlled by the CaroneElevator
// you must use the new CEDoor Mover-class for the doors and have InitialState
// set to TriggerToggle(It's default though) to get the intended Door-control

// Also IMPORTANT:
// You HAVE TO use the new CESequenceTrigger(located under Triggers/Trigger) to
// trigger the CaroneElevator
// Read below for advanced features or read the Readme-file that should be included.

// If you have bCEControlsDoors disabled and a keyframe request has been made while the
// CaroneElevator was still moving the Elevator finishes the current movement, sends out
// the CEEvents-Event for the particular Keyframe and pauses for CEDoorOpenTime seconds,
// then finishes the keyframe request.

// Update: Feb. 23, 2001 
// SlaveMover:
// With the help of Steve Tack, I managed to fix the Attach-feature of the mover-class.
// It's now possible to attach movers to the Elevator which open and close correctly
// and can also be controlled by the CaroneElevator. Although any mover-class can be
// attached to the CaroneElevator(for now) I advise you to use the CEDoor class to be able
// to take advantage of future changes without having to redo anything.

// Well, have fun with the CaroneElevator!!! If you have questions or suggestions:
// Email: dxediting@carone-online.de
// Homepage: www.carone-online.de
//==================================================================================



class CaroneElevator expands Mover;

var() bool bFollowKeyframes;


// RealisticEFactor influences the time that is subtracted from total MoveTime to create
// a more realistic Movetime.
// It makes the Movetime shorter for greater distances.
// See function SetSeq to see how it affects the movetime exactly. 
// Small RealisticEFactor=Longer MoveTime
// Making it bigger than 0.5 is senseless because MoveTime will be set to 0
// (Actually 1/NumKeys should be the max unless you are going for something special)

var (CElevatorAdvanced) float RealisticEFactor;
var (CElevatorAdvanced) float CEDoorOpenTime;
var (CElevatorAdvanced) bool bCEControlsDoors;
var (CElevatorAdvanced) bool bRealisticMovetime;
var (CElevatorAdvanced) bool bCEControlsSlave;
var (CElevatorAdvanced) name CESlaveMover;

var() float CEMoveTimes[7]; // Movetime between neighboring Keyframes (CEMoveTimes[0]=Movetime between Keyframes 0 and 1)
var() name CEEvents[8]; // Event to be triggered when CaroneElevator has moved to(or is at!!!) Keyframe(SeqNum)
var() name CEStartEvents[8]; // Send an event when CaroneElevator starts moving from specific keyframe
var() name CEStartEvent;  // Sends an event whenever CaroneElevator starts moving 
			   // Note: I didn't let it send the event when movement is finished because there already
			   // is an option for that (Event-variable)

// Internal

var int CEMoveKeys; // Number of keys from current to triggered keyframe
var float CEMoveTime; 
var int i;
var int oldkey;
var int firstkey;
var float CESleepTime;

var int CERequest;	  // If Elevator is moving while triggered for other keyframe, Elevator remembers
var bool bCERequested;    // the keynum and procedes to that keynum after finishing all the movements
 
var bool bCEDoorsOpening; // What state are CEDoors in?
var bool bCEDoorsClosed;  //
var bool bCEDoorsOpen;    //
var bool bCEDoorsClosing; //
var bool bCheckingDoors; // Damn, have to add and add and add, just to make it 'unscrewable'
var bool bCESlaveClosed; // Check the slave as well
var bool bCESlaveMoving; // Make sure the Slave is NOT MOVING when the Elevator is. It would be "FATAL"!!!
var bool bCESlaveOpen;

var bool bIsMoving;


function BeginPlay()
{
	Super.BeginPlay();
	bIsMoving = False;
}


function CEMovingTrigger()
{
	if ( CEStartEvent != '' )
	{
	foreach AllActors ( class 'Actor', Target, CEStartEvent )
					Target.Trigger( Self, Instigator );
	}
}

function CEStartTrigger()
{
	if ( CEStartEvents[oldkey] != '' )
	{
	foreach AllActors ( class 'Actor', Target, CEStartEvents[oldkey] )
					Target.Trigger( Self, Instigator );
	}
}


function CETrigger()
{
	if ( CEEvents[oldkey] != '' )
	{
	foreach AllActors( class 'Actor', Target, CEEvents[oldkey] )
					Target.Trigger( Self, Instigator );
	}

	
}

function CESlaveTrigger()
{
local Mover M;
	if ( CESlaveMover != '' )
	{
	foreach AllActors( class 'Mover', M, CESlaveMover )
				M.Trigger( Self, Instigator );
	}
}

function SetSeq(int seqnum)
{
	if (bIsMoving)
	{
		if (seqnum!=KeyNum)
		{
			bCERequested=true;
			CERequest=seqnum;
		}
		return;
	}


	if (KeyNum != seqnum) 
	{
		bCERequested=false;
		if (!bCheckingDoors)
				FirstKey=KeyNum;
		else KeyNum=FirstKey;

		CEMoveTime=0;
		oldkey=KeyNum;
		if (KeyNum>seqnum) 
		{
			for (i=seqnum;i<KeyNum;i++)
				CEMoveTime=CEMoveTime+CEMoveTimes[i];
				CEMoveKeys=KeyNum-seqnum;
		}

		if (KeyNum<seqnum)
		{
			for (i=KeyNum;i<seqnum;i++)
				CEMoveTime=CEMoveTime+CEMoveTimes[i];
				CEMoveKeys=seqnum-KeyNum;
		}

		if (bRealisticMovetime)
			{
				CEMoveTime=CEMoveTime*(1-RealisticEFactor*CEMovekeys);
				if (CEMoveTime<0) CEMoveTime=0;
			}		

		KeyNum = seqnum;

		GotoState('CaroneElevator', 'CheckDoors');
	}
	else if (KeyNum == seqnum)
	{
	GotoState('CaroneElevator', 'OpenCloseDoors');
	}
}


function CEGetMoverInfo() // To check what the hell CEDoor is doing right now :) (and get CESleeptime=CEDoor.MoveTime)
	{
	local CEDoor CED;
		CESleeptime=0;
		foreach AllActors( class 'CEDoor', CED, CEEvents[oldkey] )
			{
			if ((CED.KeyNum==0) && (!CED.bOpening) && (CED.bInterpolating)) 
				{
				bCEDoorsClosed=False;
				bCEDoorsClosing=True;
				bCEDoorsOpen=False;
				bCEDoorsOpening=False;
				}
							
			
			else if ((CED.KeyNum!=0) && (!CED.bInterpolating))
				{
				bCEDoorsClosed=False;
				bCEDoorsClosing=False;
				bCEDoorsOpen=True;
				bCEDoorsOpening=False;
				}

			else  if ((CED.KeyNum !=0) && (CED.bInterpolating) && (CED.bOpening))
				{
				bCEDoorsClosed=False;
				bCEDoorsClosing=False;
				bCEDoorsOpen=False;
				bCEDoorsOpening=True;
				}
			else 
				{
				bCEDoorsClosed=True;
				bCEDoorsClosing=False;
				bCEDoorsOpen=False;
				bCEDoorsOpening=False;
				}

				
		CESleeptime=CED.MoveTime;
			}
	}


function CECheckSlave()
	{
	local Mover M;
		CESleeptime=0;
		foreach AllActors( class 'Mover', M, CESlaveMover )
			{
				if ((M.KeyNum==0) && (!M.bOpening) && (!M.bInterpolating)) 
					{
					bCESlaveClosed=True;
					bCESlaveMoving=False;
					bCESlaveOpen=False;
					}
				else if ((M.KeyNum!=0) && (!M.bInterpolating))
					{
					bCESlaveClosed=False;
					bCESlaveMoving=False;
					bCESlaveOpen=True;
					}
				else 
					{
					bCESlaveClosed=False;
					bCESlaveMoving=True;
					bCESlaveOpen=False;
					}
				CESleeptime=M.MoveTime;
			}
	}





function CEAttachFix()   // Fixes the Attach-bug
{
local Mover M;

	foreach AllActors( class 'Mover', M )
		if (M.Attachtag==Tag)
		{
		M.BasePos = M.Location-M.KeyPos[M.KeyNum];
                M.BaseRot = M.Rotation-M.KeyRot[M.KeyNum];
		}
}

function CEDisableSlaves()
{
local Mover M;

	foreach AllActors( class 'Mover', M, CESlaveMover )
			M.Disable( 'trigger');
}

function CEEnableSlaves()
{
local Mover M;

	foreach AllActors( class 'Mover', M, CESlaveMover )
			M.Enable( 'trigger');
}


auto state() CaroneElevator
{

	function InterpolateEnd(actor Other)
	{
		if (bFollowKeyframes)
			Super.InterpolateEnd(Other);
	}

CheckDoors:
	

	if (bCEControlsDoors)
		{
		bCheckingDoors=True;
		if (bCEControlsSlave)
				{
					CECheckSlave();
					if (bCESlaveOpen)
						CESlaveTrigger();
				}

		CEGetMoverInfo();

			if ((bCEDoorsOpening) || (bCEDoorsClosing))
			{
				
				sleep(0.5);
				GotoState ( 'CaroneElevator' , 'CheckDoors' );
			}
			else if (bCEDoorsOpen)
			{
				CETrigger();
				sleep(0.5);
				GotoState ( 'CaroneElevator' , 'CheckDoors');
			}
		}
	
		Disable ( 'Trigger');

	CECheckSlave();	
	if (bCESlaveMoving)
		{
		sleep(0.5);
		GotoState('CaroneElevator' , 'CheckDoors');
		}

	If (bCEControlsSlave)
		{
		CECheckSlave();
		if (bCESlaveOpen)
			{
			CESlaveTrigger();
			Sleep(CESleepTime);
			GotoState('CaroneElevator' , 'CheckDoors');
			}
		}
			
	Enable ( 'Trigger' );


Next:
	if (bCEControlsDoors)
	{
		CEGetMoverInfo();
		if (!bCEDoorsClosed)
			GotoState('CaroneElevator' , 'CheckDoors');

		CECheckSlave();
		if (!bCESlaveClosed)
			GotoState('CaroneElevator' , 'CheckDoors');
	}

	bCheckingDoors=False;
	
	CEDisableSlaves();
	bIsMoving = True;
	CEMovingTrigger();
	CEStartTrigger();
	PlaySound(OpeningSound);
	AmbientSound = MoveAmbientSound;

	InterpolateTo(KeyNum, CEMoveTime);

	FinishInterpolation();
	AmbientSound = None;
	CEAttachfix();
	CEEnableSlaves();
	FinishedOpening();
	bIsMoving = False;
	oldkey=KeyNum;


	



// This stops any further action(after sending the "Finished-Moving"-event) 
// if DoorControl by CaroneElevator (bCEControlsDoors=False) is not wanted
// and if there hasn't been a new request
	
	if (!bCEControlsDoors)  
		{
		CETrigger();
		if (bCERequested)
		{
			sleep(CEDoorOpenTime);
			SetSeq(CERequest);
		}
		Stop;
		}


OpenCloseDoors:
		if (!bCEControlsDoors)
		{
			CETrigger();
			If (bCEControlsSlave)
				CESlaveTrigger();

			if (bCERequested)
			{
			sleep(CEDoorOpenTime);
			SetSeq(CERequest);
			}
			Stop;
		}

		CEGetMoverInfo();
		if (!bCEDoorsClosed)
			if ((bCEDoorsOpening) || (bCEDoorsClosing))
			{
			sleep(0.5);
			GotoState ( 'CaroneElevator' , 'OpenCloseDoors' );
			}
	
		if (bCEDoorsClosed)
			{
			CETrigger();
				If (bCEControlsSlave)
				{
					CECheckSlave();

					If (bCESlaveClosed)
						CESlaveTrigger();
				}
			Sleep(CESleepTime);
			Sleep(CEDoorOpenTime);
			}

	
CloseDoors:

	CEGetMoverInfo();
	if (bCEDoorsOpen)
		CETrigger();

If (bCEControlsSlave)
		{
		CECheckSlave();
		If (bCESlaveOpen)
			CESlaveTrigger();
		}


	if (bCERequested)
		SetSeq(CERequest);

	Stop;

}

defaultproperties
{
     RealisticEFactor=0.070000
     CEDoorOpenTime=5.000000
     CEMoveTimes(0)=3.000000
     CEMoveTimes(1)=3.000000
     CEMoveTimes(2)=3.000000
     CEMoveTimes(3)=3.000000
     CEMoveTimes(4)=3.000000
     CEMoveTimes(5)=3.000000
     CEMoveTimes(6)=3.000000
     MoverEncroachType=ME_CrushWhenEncroach
     InitialState=CaroneElevator
}
